<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">
	
	
	<!-- Owl Carousal -->
	<link href="<?php echo get_template_directory_uri();?>/owl/owl.carousel.min.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo get_template_directory_uri();?>/owl/owl.theme.default.css" rel="stylesheet" type="text/css" />
		
	<script src="<?php echo get_template_directory_uri();?>/owl/jquery.min.js"></script>
	<script src="<?php echo get_template_directory_uri();?>/owl/owl.carousel.js"></script>
	
	
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


<!-- Menu Section -->
<div class="full menu-section-main-sec">
	<div class="closebtn">
		<i class="fa fa-times" aria-hidden="true"></i>
	</div>
	<div class="menu-inner-main-section">
		<?php 
		echo wp_nav_menu(array('menu' => 'Main Menu'));
		?>		
	</div>
</div>




<!-- Header Bar -->
<div class="header-bar-section container">
	<!-- Logo Sec -->
	<div class="logo-section left">
		<?php 
		the_custom_logo();
		?>
	</div>
	<!-- Header Contact Section -->
	<div class="header-contact-section-main left">
		<p><a href="tel:+923053978663">P: +92 305 3978663</a></p>
		<p><a href="mailto:info@goldenkeystone.com">E: info@goldenkeystone.com</a></p>
		<p><a href="#">A: Tech Society Lahore</a></p>
	</div>
	<!-- Menu Btn Section -->
	<div class="header-menu-btn-section right">
		<i class="fa fa-bars fa-3x" aria-hidden="true"></i>
	</div>
	
	<div class="clear"></div>
</div>

