<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since Twenty Seventeen 1.0
 * @version 1.0
 */

get_header();
?>

<!-- Slider Section -->
<div class="slider-main-section-full full">
	<!--<div class="full home-page-slider owl-carousel owl-theme">-->
	<div class="full ">
	
		<?php
		$arrg = array('posts_per_page' => -1, 'post_type' => 'home_banner', 'order' => 'ASC');
		$myposts = get_posts($arrg);
		
		foreach($myposts as $post) : setup_postdata( $post );
			$PostThumbID = $post->ID;
			$SliderImageURL = wp_get_attachment_url( get_post_thumbnail_id( $PostThumbID ) );
			
		?>
			<div class="full">
				<img src="<?php echo $SliderImageURL;?>" alt="" style="width: 100%;" />
			</div>
		<?php 
			$servicecounter++;
		endforeach; 
    	wp_reset_postdata();?>
	
	</div>
</div>
<!-- Second SEction -->
<div class="full second-section-main-full">
	<div class="container">
		<!-- Spotlight Section -->
		<div class="spotlight-section-mian full">
			<h1>Our Spotlight on the Golden Keystone Landscape</h1>
			<div class="spoted-content-section-main right">
				<!--<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. quae ab illo inventore veritatis et quasi architecto quae ab illo inventore.</p>-->
				<div class="full spoted-getintouch">
					<a href="#contactus">Get in Touch</a>
				</div>
			</div>
			<div class="clear"></div>
		</div>
		<div class="spoted-second-section-full full">
			<!-- Radically Section -->
			<div class="left radically-section-main">
				<p class="top-small-heading">Aggressive growth from the foundation up</p>
				<h2>Radically<br>Collaborated Efforts</h2>
				<div class="radically-content-sec full">
					<p>We believe in exerting best and most practical resources in order to ensure the best possible solutions with minimum efforts. At Golden Keystone, our teams of professional experts work in symphony and rhyme in order to get the most practical and promising results for your situations. We choose to enforce team collaboration in our workflow in order to guarantee results.</p>
					<!--<a href="#" class="readmore">Read More</a>-->
				</div>
			</div>
			
			<!-- Radically Section -->
			<div class="right radically-right-section-main">
				<p class="top-small-heading">Time is More Precious Than Money</p>
				<h2>Fields<br>Of Activity</h2>
				<div class="radically-content-sec full">
					<p>Golden Keystone is among leading packaging manufaturing, IT services and solutions providers. Since the day of its birth, Golden Keystone is constantly progressing towards idealism by always using the most practical and most promising techniques as inputs. Instead of relying on pointless efforts, Golden Keystone always offer results which you expect after spending for the marketing and development of your businesses. </p>
					<!--<a href="#" class="readmore">Read More</a>-->
				</div>
			</div>
			
			
			<div class="clear"></div>
		</div>
	</div>
</div>
<!-- About Section -->
<div class="about-full-main-section-outer full">
	<div class="full about-sec-heading">
		<h1>About Golden Keystone</h1>
		<p>Our Services & Process</p>
	</div>
	<div class="full about-main-section">
		<!-- About Sec -->
		<div class="left about-image-half-section">
			<div class="right about-image-sec">
				<img src="<?php echo get_template_directory_uri();?>/images/about-image.jpg" alt="" />
			</div>
		</div>
		<div class="left about-content-section">
			<div class="left about-content-inner-section">
				<h3>Creative ideas are the platform for any good agency and we reckon that at Golden Keystone we’ve produced our fair share over the last 5 years. However, coming up with a good idea and then making it succeed are two different things.</h3>
				
				<p>Golden Keystone understands the trending needs and dependencies of the businesses in today’s world. Nowadays, the internet is being used by almost all businesses to extend their current customer reach as well as their standing among other businesses in their line of work. From the most innovative designs for your businesses’ websites and applications to the most promising and dependable standings of your businesses, we, at Golden Keystone, work for a better, more convenient and highly reliable web-based existence of your business.</p>
				
				<div class="full out-services-section-mian">
					<h1>Our Services</h1>
						<ul>
							<!-- <li><a href="<?php echo get_permalink(15); ?>">IT Solutions</a></li> -->
							<li><a href="<?php echo get_permalink(15); ?>">Custom Packaging</a></li>
						</ul>
					
				</div>
				
			</div>
		</div>
		
		<div class="clear"></div>
	</div>
</div>

<?php


get_footer();