<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>


<!-- Contact Us -->
<div class="contact-us-footer-main-section full" id="contactus">
	<div class="container">
		<div class="contact-us-heading full">
			<h1>Contact Us</h1>
		</div>
		
		<div class="full contact-form-section">
			
			<?php echo do_shortcode('[contact-form-7 id="9" title="Contact Form"]');?>
			
		</div>
		
		<div class="contact-section-contact-details full">
			<!-- Contact Single -->
			<div class="contact-single-sec phone-sec-contact left">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/phone-icon.png" alt="" />
				</div>
				<h4>Get in Touch</h4>	
				<p><a href="tel:+923053978663">+92 30 KEYSTONE</a></p>
			</div>
			<div class="contact-single-sec email-sec-contact left">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/email-icon.png" alt="" />
				</div>
				<h4>Email Us</h4>	
				<p><a href="mailto:key@goldenkeystone.com">key@goldenkeystone.com</a></p>
			</div>
			<div class="contact-single-sec address-sec-contact left no-margin-rignt">
				<div class="full contact-icon">
					<img src="<?php echo get_template_directory_uri();?>/images/address-icon.png" alt="" />
				</div>
				<h4>Address</h4>	
				<p><a href="#">2nd floor, Building No. 10, Commercial Market, Tech Society,Opp. Doctor Hospital, Johar town , Lahore</a></p>
			</div>
			
			<div class="clear"></div>
		</div>
	</div>
</div>
<div class="footer-bottom-bar-section full">
	<div class="container">
		<div class="right footer-menu-section">
			<?php echo wp_nav_menu(array('menu' => 'Footer Menu'));?>
		</div>
		
		<div class="left footer-copyright-section">
			<p>© 2021 Golden Keystone. All right reserved.</p>
		</div>
		<div class="clear"></div>
	</div>
</div>


<script>
$(document).ready(function(){
	// Slider on home page
	$('.home-page-slider').owlCarousel({
		loop:true,
		//margin:10,
		nav:false,
		items:1,
		dots: false,
		autoplay:true,
		slideSpeed: 2000,
	});
	
	jQuery('.header-menu-btn-section').click(function(){
		jQuery('.menu-section-main-sec').toggleClass('active');
	})
	
	jQuery('.closebtn i').click(function(){
		jQuery('.menu-section-main-sec').removeClass('active');
	})
	
	jQuery('.menu-section-main-sec ul li a').click(function(){
		jQuery('.menu-section-main-sec').removeClass('active');
	})
	
	
	//product detail multiple item slider
var bigimage = $("#big");
  var thumbs = $("#thumbs");
  //var totalslides = 10;
  var syncedSecondary = true;
  bigimage
    .owlCarousel({
    items: 1,
    slideSpeed: 2000,
    nav: false,
    autoplay: true,
    dots: false,
    loop: true,
    responsiveRefreshRate: 200,
    navText: [
      '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
      '<i class="fa fa-arrow-right" aria-hidden="true"></i>'
    ]
  })
    .on("changed.owl.carousel", syncPosition);
  thumbs
    .on("initialized.owl.carousel", function() {
    thumbs
      .find(".owl-item")
      .eq(0)
      .addClass("current");
  })
    .owlCarousel({
    items: 3,
    dots: false,
nav: true,
    navText: [
      '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
      '<i class="fa fa-arrow-right" aria-hidden="true"></i>'
    ],
    smartSpeed: 200,
    slideSpeed: 500,
    slideBy: 3,
    responsiveRefreshRate: 100
  })
    .on("changed.owl.carousel", syncPosition2);
  function syncPosition(el) {
    //if loop is set to false, then you have to uncomment the next line
    //var current = el.item.index;
    //to disable loop, comment this block
    var count = el.item.count - 1;
    var current = Math.round(el.item.index - el.item.count / 2 - 0.5);
    if (current < 0) {
      current = count;
    }
    if (current > count) {
      current = 0;
    }
    //to this
    thumbs
      .find(".owl-item")
      .removeClass("current")
      .eq(current)
      .addClass("current");
    var onscreen = thumbs.find(".owl-item.active").length - 1;
    var start = thumbs
    .find(".owl-item.active")
    .first()
    .index();
    var end = thumbs
    .find(".owl-item.active")
    .last()
    .index();
    if (current > end) {
      thumbs.data("owl.carousel").to(current, 100, true);
    }
    if (current < start) {
      thumbs.data("owl.carousel").to(current - onscreen, 100, true);
    }
  }
  function syncPosition2(el) {
    if (syncedSecondary) {
      var number = el.item.index;
      bigimage.data("owl.carousel").to(number, 100, true);
    }
  }
  thumbs.on("click", ".owl-item", function(e) {
    e.preventDefault();
    var number = $(this).index();
    bigimage.data("owl.carousel").to(number, 300, true);
  });
	
	
	
});
</script>



<?php wp_footer(); ?>




</body>
</html>
